﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Integration Result Step.
    /// </summary>
    public class GetIntegrationResultStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.IntegrationResult = srv.mcs_integrationresultSet.FirstOrDefault(x => x.cvt_controlid == state.RequestMessage.ControlId);
                if (state.IntegrationResult == null) throw new Exception($"Unable to find Integration Result for ControlId: {state.RequestMessage.ControlId}");
            }
        }
    }
}